/*
 * tn_local.h
 * File revision 2
 * Local defs for tcp net.
 * Usually you will want to replace this file with a configure generated header.
 * (c) 2002,2001 Jacob Lundberg, jacob@chaos2.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/*
 * 2001.07.15	initial revision
 * 2001.07.25	added GPL notice
 * 2002.05.20	make MSG flags portable
 */


#ifndef  __TN_LOCAL_H__
#define  __TN_LOCAL_H__


/* Avoid redefining SHUT_* if they're in sys/socket.h. */
#include <sys/socket.h>


/* Make sure dword is defined. */
#ifndef dword

typedef unsigned int dword;

#endif /* ndef dword */


/* Make sure byte is defined. */
#ifndef byte

typedef unsigned char byte;

#endif /* ndef byte */


/* Make sure boolean logic is available. */
#ifndef bool

typedef int bool;
#define  false  0
#define  true   !false

#endif /* ndef bool */


/*
 * Single Unix names flags for shutdown(). Since I'm using them,
 * I provide them here for systems that don't define them for me.
 */
#ifndef  SHUT_RD
#define  SHUT_RD        0
#endif   /* ndef SHUT_RD */

#ifndef  SHUT_WR
#define  SHUT_WR        1
#endif   /* ndef SHUT_WR */

#ifndef  SHUT_RDWR
#define  SHUT_RDWR      2
#endif   /* ndef SHUT_RDWR */


/*
 * Linux allows us to request that SIG_PIPE is ommitted when the
 * other side unexpectedly breaks the connection. So if we are on
 * Linux, we use the appropriate flag.
 */
#ifdef   MSG_NOSIGNAL
#define  MSG_FLAGS	MSG_NOSIGNAL
#else
#define  MSG_FLAGS	0
#endif


#endif /* ndef __TN_LOCAL_H__ */
